/****************************************************************************

    PROGRAM: Tate.c

    ړI: cptHĝ߂̃Tv

    ֐: WinMain()         - ֐̌ĂяoƁAbZ[W[v̏
                              s܂B
          InitApplication() - EBhEf[^̏ƁAEBhE̓o^s
                              ܂B
          InitInstance()    - CX^XnhۑāACEBhE
                              쐬܂B
          MainWndProc()     - CbZ[W܂B
          AbortProc()       - ~̂߂̃bZ[W܂B
          AbortDlg()        - ~_CAO{bNX̂߂̃bZ[W
                              ܂B
          OpenDlg()         - [U[t@CIł悤ɂ܂B
          About()           - [o[W]_CAO{bNX̃bZ[W
                              ܂B
          GetPrinterDC()    - v^̃foCXReLXg擾܂B
          GetUseFont()      - gptHg擾܂B
          StringOut()       - \܂B
          RedrawText()      - ĕ\܂B
          RefreshText()     - ̒s܂B
          PrintOut()        - ܂B
          SetInitPosition() - \ʒuobt@܂B
          SetTitle()        - EBhẼ^Cgݒ肵܂B
          f_gets()          - t@C̓ǂݎs܂B

****************************************************************************/

#include "windows.h"
#include "windowsx.h"
#include "tate.h"
#include "string.h"
#include "ime.h"
#include "commdlg.h"

HINSTANCE hInst;			/* AvP[ṼCX^Xnh */
HANDLE hHourGlass;			/* vJ[\̃nh               */
HFONT hCurrentFont;			/* gptHg̃nh             */
BYTE szMsgBuf[MAXBUF];		/* bZ[W{bNX̃bZ[W         */
BYTE szCapString[30] = "cTv - ";/* EBhẼ^Cg        */
BYTE aszString[LINENUM][BUFSIZE];	   /* ͕i[pobt@    */
WORD wCurrentAngle = 2700;	/* ̉]px                         */
UINT wScrnOutX = 10;		/* ̕\ʒu                 */
UINT wScrnOutY = 10;		/* ̕\ʒu                 */
WORD wCurrentLine = 0;		/* ͕̍s                         */
WORD wCurrentPos = 0;		/* ͕̌                         */
WORD wWndWidth;				/* NCAg̈̕                   */
BOOL bVerticalFlag = FALSE;	/* ctO                     */
BOOL bAbort;				/* ~tO                         */
BOOL bPrintable = FALSE;	/* v^tHgtO                 */
BOOL bTrueType = FALSE; 	/* TrueTypeItO                     */
BOOL bSystemFont = TRUE;	/* VXetHgItO             */

BYTE szOpenName[256] = {'\0'};	/* JĂt@C̖O */
BYTE szDefPath[256] = {'\0'};	/* pX */
BYTE szFileTitle[128];
BYTE szFilter[256];

OFSTRUCT OfStruct;	    	/* I[vt@C\                      */
HWND  hAbortDlgWnd;	    	/* ~_CAO{bNX̃nh        */
DLGPROC lpAbortDlg;	    	/* AbortDlgvV[WCX^X̃AhX  */
FARPROC lpAbortProc;		/* AbortProcvV[WCX^X̃AhX */
HANDLE	hIME;		    	/* IMEC^[tFCXp\̂̃nh */
LOGFONT LogFont;	    	/* tHg\                          */
CHOOSEFONT cf;		    	/* tHgI\                          */
OPENFILENAME ofn;	    	/* R_CAOp\                    */
COLORREF rgbColors = RGB(0, 0, 0);
                              /* eLXgJ[ */

/****************************************************************************

    ֐: WinMain(HANDLE, HANDLE, LPSTR, int)

    ړI: ֐̌ĂяoƁAbZ[W [v̏s܂B

****************************************************************************/

int PASCAL WinMain(
	HINSTANCE	hInstance,
	HINSTANCE	hPrevInstance,
	LPSTR		lpCmdLine,
	int			nCmdShow)
{
    MSG msg;

    if (!hPrevInstance)			 		/* ق̃CX^Xs?    */
		if (!InitApplication(hInstance)) /* ʂ̏                 */
	    	return (FALSE);				/* Ɏsꍇ͏I       */

    if (!InitInstance(hInstance, nCmdShow))
        return (FALSE);

    while (GetMessage(&msg, 0, 0, 0)) {
		TranslateMessage(&msg);	   /* zL[R[h̕ϊ		     */
		DispatchMessage(&msg);	   /* EBhEɃbZ[WfBXpb`   */
    }
    return (msg.wParam);	   /* PostQuitMessage̖߂lԂ          */
}


/****************************************************************************

    ֐: InitApplication(HANDLE)

    ړI: EBhEf[^̏ƁAEBhENX̓o^s܂B

****************************************************************************/

BOOL InitApplication(
	HINSTANCE hInstance)
{
    WNDCLASS  wc;

    wc.style = CS_HREDRAW | CS_VREDRAW;
    wc.lpfnWndProc = MainWndProc;
    wc.cbClsExtra = 0;
    wc.cbWndExtra = 0;
    wc.hInstance = hInstance;
	wc.hIcon = LoadIcon(NULL, IDI_APPLICATION);
    wc.hCursor = LoadCursor(NULL, IDC_ARROW);
    wc.hbrBackground = GetStockObject(WHITE_BRUSH); 
    wc.lpszMenuName =  "TateMenu";
    wc.lpszClassName = "TateWClass";

    return (RegisterClass(&wc));
}


/****************************************************************************

    ֐: InitInstance(HANDLE, int)

    ړI: CX^XnhۑāACEBhE쐬܂B

****************************************************************************/

BOOL InitInstance(
    HINSTANCE       hInstance,       /* ݂̃CX^Xʎq            */
    int             nCmdShow)        /* ŏShowWindow()Ăяö    */
{
    HWND            hWnd;            /* CEBhẼnh          */

    hInst = hInstance;

    hWnd = CreateWindow(
        "TateWClass",                  /* RegisterClass()ĂяoQ     */
        szCapString,                   /* EBhE^Cg o[̃eLXg */
        WS_OVERLAPPEDWINDOW,           /* EBhEX^C                */
        CW_USEDEFAULT,                 /* ftHg̐ʒu              */
        CW_USEDEFAULT,                 /* ftHg̐ʒu              */
        CW_USEDEFAULT,                 /* ftHg̕                    */
        CW_USEDEFAULT,                 /* ftHg̍                  */
        0,                             /* I[o[bvEBhE        */
                                       /* eEBhEȂ            */
        0,                             /* EBhENXj[gp    */
        hInstance,                     /* ̃CX^X                */
                                       /* ̃EBhEgp              */
        0                              /* |C^͕sv                    */
    );

    if (!hWnd)
        return (FALSE);

    hHourGlass = LoadCursor(NULL, IDC_WAIT);

    ShowWindow(hWnd, nCmdShow);  /* EBhE\                         */
    UpdateWindow(hWnd);          /* WM_PAINTbZ[W𑗂               */
    return (TRUE);               /* PostQuitMessage̖߂lԂ          */
}


/****************************************************************************

    ֐: GetPrinterDC(HWND, int)

    ړI: v^̃foCXReLXg擾܂B

****************************************************************************/

HANDLE GetPrinterDC(
	HWND hWnd,
	int flg)
{
    CHAR	pPrintInfo[80];
    LPSTR	lpTemp;
    LPSTR	lpPrintType;
    LPSTR	lpPrintDriver;
    LPSTR	lpPrintPort;
    HANDLE	hDriver;
    FARPROC lpDeviceMode;

    /* GetProfileString֐gČ݂̃v^̏擾 */
    if (!GetProfileString("windows", "device", (LPSTR)NULL, pPrintInfo, 80)) {
		LoadString(hInst, STR_NOPRNTDRV, szMsgBuf, MAXBUF);
		MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONQUESTION);
		return (NULL);
    }
    /* 擾[windows]ZNVdevice=tB[h */
    /* ̕eɕ                         */
    lpTemp = lpPrintType = pPrintInfo;
    lpPrintDriver = lpPrintPort = NULL;
    while (*lpTemp) {
		if (*lpTemp == ',') {
	    	*lpTemp++ = '\0';
	    	while (*lpTemp == ' ')
				lpTemp = CharNext(lpTemp);
	    	if (!lpPrintDriver)
				lpPrintDriver = lpTemp;
	    	else {
				lpPrintPort = lpTemp;
				break;
	    	}
		}
		else
			lpTemp = CharNext(lpTemp);
    }
    /* v^foCXReLXg̍쐬 */
    if (flg == 0) {
		return (CreateDC(lpPrintDriver, lpPrintType, lpPrintPort, 0));
    }
	else {
        /* v^̐ݒ */
		lstrcat(lpPrintDriver, ".DRV");
		if (!(hDriver = LoadLibrary(lpPrintDriver))) {
			LoadString(hInst, STR_NOTLOADPRNTDRV, szMsgBuf, MAXBUF);
			MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONQUESTION);
			return (NULL);
		}	
		if (!(lpDeviceMode = GetProcAddress(hDriver, "DEVICEMODE"))) {
			LoadString(hInst, STR_NOTGETADDRESS, szMsgBuf, MAXBUF);
			MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONQUESTION);
			FreeLibrary(hDriver);
			return (NULL);
		}	
		if (lpDeviceMode != NULL) {
	    	(*lpDeviceMode)(hWnd, hDriver, lpPrintType, lpPrintPort);
		}
		FreeLibrary(hDriver);
    }
}


/****************************************************************************

    ֐: GetUseFont(HWND)

    ړI: gptHg擾܂B

****************************************************************************/

VOID GetUseFont(
	HWND hWnd)
{
    if (!bSystemFont)
		DeleteObject(hCurrentFont);
    /* tHg̍쐬 */
    hCurrentFont = CreateFont(
		LogFont.lfHeight,			/* tHg̃TCY           */
		0,
		0,							/* GXP[vg() */
		0,							/* ̌                 */
		LogFont.lfWeight,
		LogFont.lfItalic,
		LogFont.lfUnderline,
		LogFont.lfStrikeOut,
		LogFont.lfCharSet,
		OUT_DEFAULT_PRECIS,
		CLIP_DEFAULT_PRECIS,
		DEFAULT_QUALITY,
		LogFont.lfPitchAndFamily,
		LogFont.lfFaceName);		/* tHgtF[X */

    /* LogFont\̂ɃtHg̏Zbg */
    GetObject(hCurrentFont, sizeof(LOGFONT), &LogFont);

    /* cptHgIƂ̓GXP[vg */
    /* ̌270xɐݒ                            */
    DeleteObject(hCurrentFont);
	if(LogFont.lfFaceName[0] == '@' && wCurrentAngle == 2700) {
		LogFont.lfEscapement = wCurrentAngle;
		LogFont.lfOrientation = wCurrentAngle;
		hCurrentFont = CreateFontIndirect(&LogFont);
		bVerticalFlag = TRUE;
    }
	else {
    	/* Cv^c */
		LogFont.lfEscapement = 0;
		LogFont.lfOrientation = 0;
		hCurrentFont = CreateFontIndirect(&LogFont);
		bVerticalFlag = FALSE;
    }
}


/****************************************************************************

    ֐: SetInitPosition( HWND )

    ړI: \ʒuobt@܂B

****************************************************************************/

VOID SetInitPosition(
	HWND hWnd)
{
    INT	i;

    wCurrentLine = 0;
    wCurrentPos = 0;
    for (i = 0; i < LINENUM; ++i)
		aszString[i][0] = '\0';

    if (!bVerticalFlag)	/* 10͗] */
		wScrnOutX = 10;
    else
		wScrnOutX = wWndWidth - 10;
    wScrnOutY = 10;
    ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
}


/****************************************************************************

    ֐: SetTitle(HWND, PSTR)

    ړI: EBhẼ^Cgݒ肵܂B

****************************************************************************/

VOID SetTitle(
	HWND hWnd,
	PSTR FontName)
{
    static BYTE szTitleString[128];		/* \p^Cg */

    lstrcpy(szTitleString, szCapString);
    lstrcat(szTitleString, FontName);
    SetWindowText(hWnd, szTitleString);
}


/****************************************************************************

    ֐: f_gets(PSTR, int, int)

    ړI: t@C1s(CR/LF܂)ǂݎ܂B

*****************************************************************************/

INT f_gets(
	CHAR TmpStr[],
	INT Length,
	HFILE hFile)
{
	INT i, ret;

    /* t@C1ǂݎAs܂EOF */
    /* B當߂lƂďʊ֐֕Ԃ     */
    for (i = 0; i < Length-1; ++i) {
		ret = _lread(hFile, &TmpStr[i], 1);
		if (ret <= 0)
			return ret;
		if (TmpStr[i] == 0x0d)
			TmpStr[i] = '\0';
		if (TmpStr[i] == 0x0a || TmpStr[i] == 0x1a)
	    	break;
    }

    TmpStr[i] = '\0';
    return (i);
}


/****************************************************************************

    ֐: StringOut(HWND, PSTR)

    ړI: \܂B

****************************************************************************/

void StringOut(
	HWND hWnd,
	PSTR pStr)
{
    HDC			hDC;
    TEXTMETRIC	tm;
    HFONT		hOldFont;		/* ̃tHg̃nh */
    SIZE		size;			/* ̕\         */

    hDC = GetDC(hWnd);

    /* eLXgJ[ݒ */
    SetTextColor(hDC, rgbColors);
    /* ݂̃tHgI */
    hOldFont = SelectObject(hDC, hCurrentFont);
    if (hOldFont != NULL) {
		/* tHg̃TCY擾 */
		GetTextMetrics(hDC, &tm);
		bTrueType = tm.tmPitchAndFamily & TMPF_TRUETYPE;
		/* sꂽꍇA܂͍sɒBꍇ͉s */
		if (*pStr == 0x0d || wCurrentPos + lstrlen(pStr) + 1 >= BUFSIZE) {
	    	wCurrentPos = 0;
	    	++wCurrentLine;
	    	/* \Jnʒu̍s̐擪ɐi߂ */
	    	if (wCurrentLine < LINENUM) {
				if (!bVerticalFlag) {
		    		wScrnOutX  = 10;
		    		wScrnOutY += tm.tmHeight;
				}
				else {
		    		wScrnOutX -= tm.tmHeight;
		    		wScrnOutY  = 10;
				}
				ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
	    	}
			else {
				*pStr = 0x0d; /* ̏I */
			}
		}

		if (*pStr != 0x0d) {
	    	/* o͂镶obt@Ɋi[ */
	    	lstrcat(aszString[wCurrentLine], pStr);
	    	wCurrentPos += lstrlen(pStr);
	    	/* ̎ۂ̕\ƍ擾 */
			GetTextExtentPoint(hDC, pStr, lstrlen(pStr), &size);
	    	/* \ */
	    	TextOut(hDC, wScrnOutX, wScrnOutY, pStr, lstrlen(pStr));
	    	/* \Jnʒu̐̕擪ɐi߂ */
	    	if (!bVerticalFlag) {
				wScrnOutX += size.cx;
	    	}
			else {
				if (bTrueType)
		    		/* TrueTypeł͕\̕ƍ͗p̌ɑΉ */
		    		wScrnOutY += size.cx;
				else
		    		wScrnOutY += size.cy;
	    	}
			/* IMEϊEBhËʒui߂ */
	    	ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
		}
		/* ̃tHgɖ߂ */
		SelectObject(hDC, hOldFont);
    }
    ReleaseDC(hWnd, hDC);
}


/****************************************************************************

    ֐: RedrawText(HWND, HDC)

    ړI: ĕ\܂B

****************************************************************************/

VOID RedrawText(
	HWND hWnd,
	HDC hDC)
{
    TEXTMETRIC	tm;
    INT			i;
    UINT		x, y;
    HFONT		hOldFont;			/* ̃tHg̃nh */

    /* eLXgJ[ݒ */
    SetTextColor(hDC, rgbColors);
    /* ݂̃tHgI */
    hOldFont = SelectObject(hDC, hCurrentFont);
    if (hOldFont != NULL) {
		/* tHg̃TCY擾 */
		GetTextMetrics(hDC, &tm);
		/* sƂɃobt@Ɋi[ꂽ\ */
		if (!bVerticalFlag)
	    	x = 10;
		else
	    	x = wWndWidth - 10;
		y = 10;
		for (i = 0; i <= wCurrentLine; ++i) {
	    	TextOut(hDC, x, y, aszString[i], lstrlen(aszString[i]));
	    	if (!bVerticalFlag)
				y += tm.tmHeight;
	    	else
				x -= tm.tmHeight;
		}
		/* c̏ꍇ͈ʒuĐݒ */
    	if(bVerticalFlag) 
    		wScrnOutX = x + tm.tmHeight;
		/* ̃tHgɖ߂ */
		SelectObject(hDC, hOldFont);
    }
}


/****************************************************************************

    ֐: RefreshText(HWND hWnd)

    ړI: tHgύXƂɂ̊֐ĂяoāAʂ𐮂܂B

****************************************************************************/

VOID RefreshText(
	HWND hWnd)
{
    HDC 		hDC;
    TEXTMETRIC	tm;
    HFONT		hOldFont;		/* ̃tHg̃nh */
    SIZE		size;			/* ̕\         */

    hDC = GetDC(hWnd);
    /* ݂̃tHgI */
    hOldFont = SelectObject(hDC, hCurrentFont);
    if (hOldFont != NULL) {
		/* tHg̃TCY擾 */
		GetTextMetrics(hDC, &tm);
		bTrueType = tm.tmPitchAndFamily & TMPF_TRUETYPE;
		/* ̎ۂ̕\ƍ擾 */
		GetTextExtentPoint(hDC, aszString[wCurrentLine],
						lstrlen(aszString[wCurrentLine]), &size);
		/* ̕\JnʒuvZċ߂ */
		if (!bVerticalFlag) {
	    	wScrnOutX = 10 + size.cx;
	    	wScrnOutY = 10 + tm.tmHeight * wCurrentLine;
		}
		else {
	    	wScrnOutX = wWndWidth - 10 - tm.tmHeight * wCurrentLine;
	    	if (bTrueType)
				/* TrueTypeł͕\̕ƍ͗p̌ɑΉ */
				wScrnOutY = 10 + size.cx;
	    	else
				wScrnOutY = 10 + size.cy;
		}
		/* IMEϊEBhËʒui߂ */
		ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
		/* ̃tHgɖ߂ */
    	SelectObject(hDC, hOldFont);
    }
    ReleaseDC(hWnd, hDC);
    /* EBhEŜĕ` */
    InvalidateRect(hWnd, NULL, TRUE);
    UpdateWindow(hWnd);
}


/****************************************************************************

    ֐: PrintOut(HDC, HWND)

    ړI: ܂B

****************************************************************************/

void PrintOut(hPrDC, hWnd)
HDC hPrDC;
HWND hWnd;
{
    INT		Px;
    INT 	Py;
    HFILE 	hFile;
    INT 	LineSpace;			/* sԊu        */
    INT 	LinesPerPage;		/* 1y[W̍s */
    INT 	CurrentLine;		/* ݍs        */
    INT 	i;
    POINT	Point;				/* 󎚃TCY    */
    HANDLE	hSaveCursor;		/* ݂̃J[\ۑ邽߂̃nh */
    HFONT	hOldFont;			/* ݂̃tHg̃nh               */
    static BYTE abPrintBuffer[MAXBUF];	/* t@Cpobt@ */
    TEXTMETRIC tm;
	DOCINFO	diPrint;

    hSaveCursor = SetCursor(hHourGlass);

    /* ~vV[Wƃ_CAOvV[W */
    /* ̃CX^XAhX쐬                 */
    lpAbortDlg  = MakeProcInstance(AbortDlg,  hInst);
    lpAbortProc = MakeProcInstance(AbortProc, hInst);

    if (!bSystemFont)
		hOldFont = SelectObject(hPrDC, hCurrentFont);

	diPrint.cbSize = sizeof(DOCINFO);
	diPrint.lpszDocName = "Tate";
	diPrint.lpszOutput = NULL;
	
	/* ~vV[W̐ݒAv */
	if (SetAbortProc(hPrDC, (PROC)lpAbortProc) < 0
	||  StartDoc(hPrDC, &diPrint) == SP_ERROR || StartPage (hPrDC) < 0) {
		/* G[̏ */
		SetCursor(hSaveCursor); 	 /* vJ[\̃J[\ɖ߂ */
		LoadString(hInst, STR_CANNOTPRINT, szMsgBuf, MAXBUF);
		MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONINFORMATION);
		FreeProcInstance(AbortDlg);
		FreeProcInstance(AbortProc);
		return;
	}

	bAbort = FALSE; 					/* ~tONA */
	/* ~_CAO{bNX쐬 */
	hAbortDlgWnd = CreateDialog(hInst, "AbortDlg", hWnd, lpAbortDlg);
	ShowWindow (hAbortDlgWnd, SW_NORMAL);
    UpdateWindow (hAbortDlgWnd);
	/* CEBhE𖳌 */
	EnableWindow(hWnd, FALSE);

    /* \tmɃtHg̏i[ */
    GetTextMetrics(hPrDC, &tm);

    /* sԊutmHeightotmExternalLeadingo̘a */
    LineSpace = tm.tmHeight + tm.tmExternalLeading;

    /* GetDeviceCaps֐ɂ󎚔͈͂̃TCY擾 */
    Point.x = GetDeviceCaps(hPrDC, HORZRES) - 20;  /* 20͉E[̗] */
    Point.y = GetDeviceCaps(hPrDC, VERTRES);
    
	/* 1y[W̍svZ */
    if (!bVerticalFlag)
		LinesPerPage = Point.y / LineSpace;
    else
		LinesPerPage = Point.x / LineSpace;

	/* 󎚊Jnʒuݒ */
    if (!bVerticalFlag)
		Px = 0;
    else
		Px = Point.x;
    Py = 0;

    SetCursor(hSaveCursor);          /* vJ[\̃J[\ɖ߂ */

    if (hOldFont != NULL) {
	/* ݍs1ɐݒ */
	CurrentLine = 1;
	/* JĂt@Cꍇ */
	if (szOpenName[0] != '\0') {
	    /* t@CĂъJ */
	    hFile = OpenFile((LPSTR) NULL, &OfStruct, OF_REOPEN | OF_READ);
	    for ( ; ; ) {
			if (f_gets(abPrintBuffer, MAXBUF, hFile) <= 0)
				break;
			if (abPrintBuffer[0] != '\0')
		    	TextOut(hPrDC, Px, Py, abPrintBuffer, lstrlen(abPrintBuffer));
			/* ̈󎚈ʒuݒ */
			if (!bVerticalFlag)
		    	Py += LineSpace;
			else
		    	Px -= LineSpace;
			/* s1y[W𒴂ꍇɂ͉y[W */
			if (++CurrentLine > LinesPerPage) {
			    if (!EndPage (hPrDC) || StartPage (hPrDC) < 0 || bAbort)
					break;
		    	if (!bSystemFont)
					SelectObject(hPrDC, hCurrentFont);
		    	CurrentLine = 1;
		    	if (!bVerticalFlag)
					Px = 0;
		    	else
					Px = Point.x;
		    	Py = 0;
			}
	    }
	}
	else {
		/* [U[͂eLXgꍇ */
	    for (i = 0; i <= wCurrentLine; ++i) {
			if (aszString[i][0] != '\0')
		    	TextOut(hPrDC, Px, Py, aszString[i], lstrlen(aszString[i]));
			if (!bVerticalFlag)
		    	Py += LineSpace;
			else
		    	Px -= LineSpace;
			if (++CurrentLine   +  1   > LinesPerPage) {
			    if (!EndPage (hPrDC) || StartPage (hPrDC) < 0 || bAbort)
					break;
		    	if (!bSystemFont)
					SelectObject(hPrDC, hCurrentFont);
		    	CurrentLine = 1;
		    	if (!bVerticalFlag)
					Px = 0;
		    	else
					Px = Point.x;
		    	Py = 0;
			}
	    }
	}
		if (!bSystemFont)
			SelectObject(hPrDC, hOldFont);
    }
    
	if (!bAbort) {
		Escape(hPrDC, NEWFRAME, 0, 0L, 0L);
		Escape(hPrDC, ENDDOC, 0, 0L, 0L);
    }
	
    /* CEBhELĈ~_CAOj */
    EnableWindow(hWnd, TRUE);
    DestroyWindow(hAbortDlgWnd);
    FreeProcInstance(AbortDlg);
    FreeProcInstance(AbortProc);
}


/****************************************************************************

    ֐: AbortProc(HDC, int)

    ړI: ~̂߂̃bZ[W܂B

****************************************************************************/

int FAR PASCAL AbortProc(
	HDC hPr,                        /* ̃v^fBXvC */
                                    /* ReLXgɑΉ         */
	INT Code)                       /* ̃Xe[^X           */
{
    MSG msg;

    /* ~_CAO{bNX̃bZ[W */
    while (!bAbort && PeekMessage(&msg, 0, 0, 0, TRUE)) {
        if (!IsDialogMessage(hAbortDlgWnd, &msg)) {
            TranslateMessage(&msg);
            DispatchMessage(&msg);
        }
	}	
    /* [U[~Iꍇɂ́AbAbortTRUE */
    return (!bAbort);
}


/****************************************************************************

    ֐:       AbortDlg(HWND, unsigned, WORD, LONG)

    ړI:       ~_CAO{bNX̂߂̃bZ[W܂B

    bZ[W: WM_INITDIALOG - _CAO{bNX̏
                WM_COMMAND    - ͂󂯎Ƃ

    Rg:

        ̃_CAO{bNX͈ɍ쐬Aɂ胆[U[͈
        rŒ~邱Ƃł܂B

****************************************************************************/

int FAR PASCAL AbortDlg(
	HWND	hDlg,
	UINT	msg,
	WPARAM	wParam,
	LPARAM	lParam)
{
    switch(msg) {

        /* ~̃bZ[W([ݾ]{^)ɂ */
        /* bAbortTRUEɃZbg                      */
        case WM_COMMAND:
            return (bAbort = TRUE);

        case WM_INITDIALOG:
            /* _CAO[ݾ]{^ɃtH[JXݒ */
            SetFocus(GetDlgItem(hDlg, IDCANCEL));
	    	if (szOpenName[0] != '\0')
				SetDlgItemText(hDlg, IDC_FILENAME, (LPSTR)szOpenName);
	    	else
				SetDlgItemText(hDlg, IDC_FILENAME, (LPSTR)"eLXg");
            return (TRUE);
    }
    return (FALSE);
}


/****************************************************************************

    ֐:       MainWndProc(HWND, unsigned, WORD, LONG)

    ړI:       CbZ[W܂B

    bZ[W: WM_CREATE     - CEBhEJƂ̐ݒ
                WM_PAINT      - EBhE̍ĕ`
                WM_COMMAND    - AvP[Vj[
                WM_CHAR       - 
                WM_DESTROY    - EBhE̔j

****************************************************************************/

LRESULT FAR PASCAL MainWndProc(
	HWND hWnd,							/* EBhEnh 			 */
	UINT message,						/* bZ[W̃^Cv 			 */
	WPARAM wParam,						/* t						 */
	LPARAM lParam)						/* t						 */
{
    DLGPROC lpProcAbout;		/* About֐w|C^	     */
    HDC		hDC;
    HDC 	hPrDC;
    PAINTSTRUCT ps;
    HFILE 	hFile;
    INT 	len;
    HANDLE hSaveCursor;         /* ݂̃J[\ۑ邽߂̃nh */

    switch (message) {
	case WM_CREATE:		/* CEBhEJƂ̐ݒ */
	    hCurrentFont = GetStockObject(SYSTEM_FONT);

	    SetTitle(hWnd, "VXe");

	    EnableMenuItem(GetMenu(hWnd), 2,MF_BYPOSITION | MF_GRAYED);
	    DrawMenuBar(hWnd);

	    hIME = GlobalAlloc( GHND, (LONG)sizeof(IMESTRUCT) );
	    break;

	case WM_SIZE:		/* EBhẼTCYύXꂽƂ̏ */
	    wWndWidth  = LOWORD(lParam);
	    ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
	    break;

	case WM_MOVE:		/* EBhEړƂ̏ */
	    ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
	    break;
	    
	case WM_PAINT:		/* EBhE̍ĕ` */
	    hDC = BeginPaint(hWnd, &ps);
	    RedrawText(hWnd, hDC);
	    EndPaint(hWnd, &ps);
	    ImeMoveConvertWin( hWnd, wScrnOutX, wScrnOutY );
	    break;

	case WM_COMMAND:
		switch(GET_WM_COMMAND_ID(wParam, lParam)) {
		case IDM_ABOUT:      /* [o[W]_CAO   */
                                     /* {bNXJ               */
		    lpProcAbout = MakeProcInstance(About, hInst);
		    DialogBox(hInst, "AboutBox", hWnd, lpProcAbout);
		    FreeProcInstance(lpProcAbout);
		    break;

		case IDM_PRINT:      /* ڂ̑I */
		    hPrDC = GetPrinterDC(hWnd, 0);
		    if (!hPrDC)
				return (0);
		    if (bPrintable || bSystemFont) {
				PrintOut(hPrDC, hWnd);
		    }
			else {
				LoadString(hInst, STR_SCREENONLY, szMsgBuf, MAXBUF);
				MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONINFORMATION);
		    }
		    DeleteDC(hPrDC);
		    break;

		case IDM_PRNTSET:    /* v^̐ݒ */
		    GetPrinterDC(hWnd, 1);
		    break;

		case IDM_OPEN:       /* t@CJ */
		    hFile = OpenDlg(hWnd);
		    /* t@CJ炻̓eobt@ɓǂݍ */
		    if (hFile != 0) {
				hSaveCursor = SetCursor(hHourGlass);
				SetInitPosition( hWnd );
				for (wCurrentLine = 0; wCurrentLine < 50; ++wCurrentLine) {
			    	if ((f_gets(aszString[wCurrentLine],BUFSIZE, hFile)) <= 0)
						break;
				}
				_lclose(hFile);
				InvalidateRect(hWnd, NULL, TRUE);
				UpdateWindow(hWnd);
				SetCursor(hSaveCursor);
		    }
		    break;

		case IDM_SELECT:     /* tHg̑I */
		    {
			BOOL fNoErr;
			HDC  hPrDC;
			
			memset(&cf, 0, sizeof(CHOOSEFONT));
			cf.lStructSize = sizeof(CHOOSEFONT);
			cf.hwndOwner = hWnd;
			cf.lpLogFont = &LogFont;
			
			if (hPrDC = GetPrinterDC(hWnd, 0)) {
			    cf.Flags = CF_EFFECTS | CF_BOTH | CF_INITTOLOGFONTSTRUCT;
			    cf.hDC = hPrDC;
			}
			else {
 			    cf.Flags = CF_EFFECTS | CF_SCREENFONTS | CF_INITTOLOGFONTSTRUCT;			}
			
			fNoErr = ChooseFont(&cf);
			
			if (hPrDC)
				DeleteDC(hPrDC);
			
			if (!fNoErr)
			    break;
			
			rgbColors = cf.rgbColors;
			bPrintable = cf.nFontType & PRINTER_FONTTYPE ? TRUE : FALSE;
			bSystemFont = FALSE;

		    /* gptHg쐬 */
		    GetUseFont(hWnd);
		    SetTitle(hWnd, LogFont.lfFaceName);
		    
			/* cptHg̏ꍇ̓[hIł悤ɂ */
		    if (LogFont.lfFaceName[0] == '@')
				EnableMenuItem(GetMenu(hWnd), 2, MF_BYPOSITION | MF_ENABLED);
			else
				EnableMenuItem(GetMenu(hWnd), 2, MF_BYPOSITION | MF_GRAYED);
		    DrawMenuBar(hWnd);

		    RefreshText(hWnd);
		    
			break;
			}
		case IDM_SYSTEM:     /* VXetHgI */
		    if (!bSystemFont)
				DeleteObject(hCurrentFont);
		    hCurrentFont = GetStockObject(SYSTEM_FONT);
		    GetObject(hCurrentFont, sizeof(LOGFONT), (LPSTR) &LogFont);
		    SetTitle(hWnd, "VXe");
		    /* VXetHg̏ꍇɂ͏c͕s */
		    EnableMenuItem(GetMenu(hWnd), 2, MF_BYPOSITION | MF_GRAYED);
		    DrawMenuBar(hWnd);
		    bVerticalFlag = FALSE;
		    bPrintable = FALSE;
		    bSystemFont = TRUE;

		    RefreshText(hWnd);
		    break;

		case IDM_SYSTEMFIXED:/* VXeŒtHgI */
		    if (!bSystemFont)
				DeleteObject(hCurrentFont);
		    hCurrentFont = GetStockObject(SYSTEM_FIXED_FONT);
		    GetObject(hCurrentFont, sizeof(LOGFONT), (LPSTR) &LogFont);
		    SetTitle(hWnd, "VXeŒ");
		    /* VXeŒtHg̏ꍇɂ͏c͕s */
		    EnableMenuItem(GetMenu(hWnd), 2, MF_BYPOSITION | MF_GRAYED);
		    DrawMenuBar(hWnd);
		    bVerticalFlag = FALSE;
		    bPrintable    = FALSE;
		    bSystemFont = TRUE;

		    RefreshText(hWnd);
		    break;

		case IDM_LINEPRNT:   /* Cv^̕ŕ\܂͈ */
		    CheckMenuItem(GetMenu(hWnd), IDM_LINEPRNT, MF_CHECKED);
		    CheckMenuItem(GetMenu(hWnd), IDM_NVERTIC, MF_UNCHECKED);
		    wCurrentAngle = 0;
		    GetUseFont(hWnd);
		    RefreshText(hWnd);
		    break;

		case IDM_NVERTIC:   /* ʏ̏cŕ\܂͈ */
		    CheckMenuItem(GetMenu(hWnd), IDM_NVERTIC, MF_CHECKED);
		    CheckMenuItem(GetMenu(hWnd), IDM_LINEPRNT, MF_UNCHECKED);
		    wCurrentAngle = 2700;
		    GetUseFont(hWnd);
		    RefreshText(hWnd);
		    break;

		case IDM_CLEAR:     /* ʂNA */
		    SetInitPosition( hWnd );
		    szOpenName[0] = '\0';
		    InvalidateRect(hWnd, 0, TRUE);
		    UpdateWindow(hWnd);
		    break;

		case IDM_QUIT:      /* I */
		    if (!bSystemFont)
				DeleteObject(hCurrentFont);
		    PostQuitMessage(0);
		    break;

		default:		       /* WindowsbZ[W */
		    return (DefWindowProc(hWnd, message, wParam, lParam));
	    }
	    break;

	case WM_CHAR:		/* ͂ꂽ1 */
	{
	    static BOOL KanjiFlag = FALSE;   /* ͕̏ꍇ̃tO */
	    static BYTE szOutStr[3] = {'\0'}; /* o͕pobt@ */
	
	    /* ͕pobt@Ɋi[ */
	    if (wCurrentLine >= LINENUM)
			break;

	    /* ̑1oCg̏ꍇ͑2oCgڂ܂ */
	    /* ҂ĂStringOut֐ɑ          */
	    if (!KanjiFlag && IsDBCSLeadByte((BYTE)wParam)) {
			szOutStr[0] = (CHAR) wParam;
			szOutStr[1] = '\0';
			KanjiFlag = TRUE;
	    }
		else {
            if(!KanjiFlag && !isprint(wParam))
                break;
			len = lstrlen(szOutStr);
			szOutStr[len] = (char) wParam;
			szOutStr[len + 1] = '\0';

			StringOut(hWnd, szOutStr);

			szOutStr[0] = '\0';
			KanjiFlag = FALSE;
	    }
	    break;
	}

	case WM_KILLFOCUS:
	    ImeMoveConvertWin( hWnd, -1, -1 );
	    break;

	case WM_DESTROY:	/* EBhEp */
	    if (!bSystemFont)
			DeleteObject(hCurrentFont);
	    PostQuitMessage(0);
	    GlobalFree( hIME );
	    break;

	default:			  /* bZ[W͂̂܂ܓn */
	    return (DefWindowProc(hWnd, message, wParam, lParam));
    }
    return (0);
}


/****************************************************************************

    ֐: OpenDlg(HWND)

    ړI: [U[t@CIł悤ɂ܂B

****************************************************************************/

HFILE OpenDlg(
	HWND hWnd)
{
    WORD	wCnt;
    BYTE	chReplace;
    HFILE	hFile;

    if ((wCnt = LoadString(hInst, STR_FILTERSTRING,
							szFilter, sizeof(szFilter))) == 0) {
		return 0;
    }
    chReplace = szFilter[wCnt - 1];
    for (wCnt = 0; szFilter[wCnt]; wCnt++) {
		if (szFilter[wCnt] == chReplace)
	    	szFilter[wCnt] = '\0';
    }
    memset(&ofn, 0, sizeof(OPENFILENAME));
    ofn.lStructSize     = sizeof(OPENFILENAME);
    ofn.hwndOwner       = hWnd;
    ofn.lpstrFilter     = szFilter;
    ofn.nFilterIndex    = 1;
    ofn.lpstrFile       = szOpenName;
    ofn.nMaxFile        = sizeof(szOpenName);
    ofn.lpstrFileTitle  = szFileTitle;
    ofn.nMaxFileTitle   = sizeof(szFileTitle);
    ofn.lpstrInitialDir = szDefPath;
    ofn.Flags           = OFN_SHOWHELP | OFN_PATHMUSTEXIST |
						  OFN_FILEMUSTEXIST;
    if (!GetOpenFileName(&ofn))
		return 0;

    hFile = OpenFile(szOpenName, &OfStruct, OF_READ);
    if (hFile == 0) {
		LoadString(hInst, STR_CANNOTOPEN, szMsgBuf, MAXBUF);
		MessageBox(hWnd, szMsgBuf, NULL, MB_OK | MB_ICONHAND);
		return 0;
    }

    /* t@CJt@CnhԂ */
    return hFile;
}


/****************************************************************************

    ֐:       About(HWND, unsigned, WORD, LONG)

    ړI:       [o[W]_CAO{bNX̃bZ[W܂B

    bZ[W: WM_INITDIALOG - _CAO{bNX̏
                WM_COMMAND    - ͂󂯎Ƃ

****************************************************************************/

BOOL FAR PASCAL About(
	HWND	hDlg,			   /* _CAO{bNXEBhẼnh */
	UINT	message,		   /* bZ[W̃^Cv					 */
	WPARAM	wParam,			   /* bZ[WŗL̏					 */
	LPARAM	lParam)
{
    switch (message) {
	case WM_INITDIALOG:	/* _CAO{bNX */
	    return (TRUE);

	case WM_COMMAND:	/* R}h󂯎 */
		switch(GET_WM_COMMAND_ID(wParam, lParam)) {
		case IDOK:						  /* [OK]{^I */
		case IDCANCEL:
			EndDialog(hDlg, TRUE);		  /* _CAO{bNX */
			return (TRUE);
		}
	    break;
    }
    return (FALSE);		/* bZ[WȂꍇ */
}


/****************************************************************************

    ֐: ImeMoveConvertWin(HWND, int, int )

    ړI: {ϊobt@̕\ʒuύX܂B

****************************************************************************/

VOID ImeMoveConvertWin(
	HWND hWnd,
	INT x,
	INT y)
{
    LPIMESTRUCT lpIme;

    if( lpIme = (LPIMESTRUCT)GlobalLock( hIME ) ){
		/* Tut@NVԍIME_SETCONVERSIONWINDOWݒ */
		lpIme->fnc = IME_SETCONVERSIONWINDOW;
		if( x == -1 && y == -1 ) {
	    	lpIme->wParam = MCW_DEFAULT;
		}
		else {
	    	if (!bVerticalFlag)
				lpIme->wParam = MCW_WINDOW;
	    	else
				lpIme->wParam = MCW_WINDOW | MCW_VERTICAL;
		}
		lpIme->lParam1 = MAKELONG( x, y );
		GlobalUnlock( hIME );
		SendIMEMessageEx( hWnd, (LPARAM)hIME);
    }
}


/****************************************************************************

	֐: ImeSetFont(HWND, HFONT)

	ړI:  hldϊEBhEŎgptHgw肵܂B


****************************************************************************/

VOID ImeSetFont(
	HWND  hWnd,
	HANDLE hFontLF)
{
	LPIMESTRUCT lpIme;

	if (lpIme = (LPIMESTRUCT)GlobalLock(hIME)) {
		/* Tut@NVԍIME_SETCONVERSIONFONTEXݒ肷 */
		lpIme->fnc = IME_SETCONVERSIONFONTEX;
		/* _tHg\̂̃nhIME\̂ɐݒ肷 */
		lpIme->lParam1 = (LPARAM)hFontLF;
		GlobalUnlock(hIME);
		/* ʏIMEC^[tFCX֐Ăяo */
		SendIMEMessageEx(hWnd, (LPARAM)hIME);
		/* _tHg\̂̃J */
		if (hFontLF) {
			GlobalFree(hFontLF);
		}	
	}
}
